local assets=
{
	Asset("ANIM", "anim/warsaw939.zip"),
	Asset("ATLAS", "images/inventoryimages/warsaw939.xml"),
    Asset("IMAGE", "images/inventoryimages/warsaw939.tex"),
}

local prefabs =
{

}

local function OnHit(inst, owner, target)
    inst:Remove()    
end

-- local function oncollide(inst, owner, target, other)
	-- if other and other.components.workable and  other.components.workable.workleft > 0 then
	-- other.components.workable.workleft = workleft - 1
	-- inst:Remove()
	-- end
	-- inst:Remove()
-- end

local function fncommon(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("warsaw939")
    inst.AnimState:SetBuild("warsaw939")
    inst.AnimState:PlayAnimation("idle", false)
	
	inst:AddTag("projectile")
			
    inst:AddComponent("stackable")	 
	inst.components.stackable.maxsize = 40
	
	inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(100)
	inst.components.projectile:SetOnHitFn(OnHit)
    inst.components.projectile:SetOnMissFn(OnHit)
	
	-- inst.Physics:SetCollisionCallback(oncollide)
	--inst.Physics:SetCollisionGroup(COLLISION.FLYERS)
    -- inst.Physics:ClearCollisionMask()
    -- inst.Physics:CollidesWith(COLLISION.WORLD)
	-- inst.Physics:CollidesWith(COLLISION.OBSTACLES)
	
    inst:AddComponent("inspectable")
	
	-- inst:ListenForEvent("collide", oncollide)
    	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warsaw939.xml"

	return inst
end



STRINGS.NAMES.WARSAW939 = "9x39mm"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WARSAW939 = "Ammo for the warsaw weapons."


return Prefab( "common/inventory/warsaw939", fncommon, assets)
